
ChangeContractSettingsEvent = {}
ChangeContractSettingsEvent_mt = Class(ChangeContractSettingsEvent, Event)
InitEventClass(ChangeContractSettingsEvent, "ChangeContractSettingsEvent")

ChangeContractSettingsEvent.NUM_BITS_SETTINGS_ID = 1
ChangeContractSettingsEvent.NUM_BITS_STATE = 2

---Create instance of Event class
-- @return table self instance of class event
function ChangeContractSettingsEvent.emptyNew()
    local self = Event.new(ChangeContractSettingsEvent_mt)
    return self
end


---Create new instance of event
-- @param table object object
-- @param boolean isBlocked is blocked
function ChangeContractSettingsEvent.new(settingsId, state)
    local self = ChangeContractSettingsEvent.emptyNew()
    self.settingsId = settingsId
    self.state = state
    return self
end


---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
function ChangeContractSettingsEvent:readStream(streamId, connection)
    self.settingsId =   streamReadString(streamId, ChangeContractSettingsEvent.NUM_BITS_SETTINGS_ID)
    self.state = streamReadInt8(streamId, ChangeContractSettingsEvent.NUM_BITS_STATE)
    self:run(connection)

end


---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
function ChangeContractSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, ChangeContractSettingsEvent.NUM_BITS_SETTINGS_ID)
    streamWriteInt8(streamId, self.state, ChangeContractSettingsEvent.NUM_BITS_STATE)
end


---Run action on receiving side
-- @param integer connection connection
function ChangeContractSettingsEvent:run(connection)
   
    if(self.settingsId == "leaseVehicle") then
        g_r_contracts.leaseVehicle = self.state
    elseif(self.settingsId == "missionPerFarm") then
        g_r_contracts.missionPerFarm = self.state
    elseif(self.settingsId == "allowClearAdd") then
        g_r_contracts.allowClearAdd = self.state
    end
    if g_server ~= nil then

        if(self.settingsId == "missionPerFarm") then
            if self.state == 11 then
                MissionManager.MAX_MISSIONS_PER_FARM = 100
            else
                MissionManager.MAX_MISSIONS_PER_FARM = self.state - 1
            end
        end

        g_server:broadcastEvent(self, false)
    end
end

