---
--- Created by Ragman2414.
--- DateTime: 21.02.2022
---


LoadContractSettingsEvent = {}
LoadContractSettingsEvent_mt = Class(LoadContractSettingsEvent, Event)
InitEventClass(LoadContractSettingsEvent, "LoadContractSettingsEvent")

LoadContractSettingsEvent.NUM_BITS_SETTINGS_LEASE_VEHICLE = 1
LoadContractSettingsEvent.NUM_BITS_SETTINGS_MISSION_PER_FARM = 2
LoadContractSettingsEvent.NUM_BITS_SETTINGS_ALLOW_CLEAR_ADD = 3


---Create instance of Event class
function LoadContractSettingsEvent.emptyNew()
    local self = Event.new(LoadContractSettingsEvent_mt)
    return self
end


---Create new instance of event
function LoadContractSettingsEvent.new(leaseVehicle, missionPerFarm, allowClearAdd)
    local self = LoadContractSettingsEvent.emptyNew()
    self.leaseVehicle = leaseVehicle
    self.missionPerFarm = missionPerFarm
    self.allowClearAdd = allowClearAdd
    return self
end


---Called on client side on join
function LoadContractSettingsEvent:readStream(streamId, connection)

    if g_server == nil then
        self.leaseVehicle = streamReadInt32(streamId, LoadContractSettingsEvent.NUM_BITS_SETTINGS_LEASE_VEHICLE)
        self.missionPerFarm = streamReadInt32(streamId, LoadContractSettingsEvent.NUM_BITS_SETTINGS_MISSION_PER_FARM)
        self.allowClearAdd = streamReadInt32(streamId, LoadContractSettingsEvent.NUM_BITS_SETTINGS_ALLOW_CLEAR_ADD)

        self:run(connection)
    end


end


    ---Called on server side on join
    function LoadContractSettingsEvent:writeStream(streamId, connection)

    if(g_r_contracts.allowClearAdd ~= nil) then
        streamWriteInt32(streamId, g_r_contracts.allowClearAdd, LoadContractSettingsEvent.NUM_BITS_SETTINGS_ALLOW_CLEAR_ADD)
    end

    if(g_r_contracts.missionPerFarm ~= nil) then
        streamWriteInt32(streamId, g_r_contracts.missionPerFarm , LoadContractSettingsEvent.NUM_BITS_SETTINGS_MISSION_PER_FARM)
    end

    if(g_r_contracts.leaseVehicle ~= nil) then
        
        streamWriteInt32(streamId, g_r_contracts.leaseVehicle, LoadContractSettingsEvent.NUM_BITS_SETTINGS_LEASE_VEHICLE)
    end


    end


    ---Run action on receiving side
    function LoadContractSettingsEvent:run(connection)
        if g_server ~= nil then
            g_server:broadcastEvent(LoadContractSettingsEvent.new(
                    g_r_contracts.leaseVehicle,
                    g_r_contracts.missionPerFarm,
                    g_r_contracts.allowClearAdd), false)
            return
        end

        if(self.leaseVehicle ~= nil) then
            g_r_contracts.leaseVehicle = self.leaseVehicle
        end
        if(self.missionPerFarm  ~= nil) then
            g_r_contracts.missionPerFarm = self.missionPerFarm
        end
        if(self.allowClearAdd  ~= nil) then
            g_r_contracts.allowClearAdd = self.allowClearAdd
        end
    end


